/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.weaponpassives;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.forixaim.battle_arts.DebugControls;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.BattleStyleCategories;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.forixaim.bs_api.battle_arts_skills.battle_style.BattleStyle;
import net.forixaim.efm_ex.skill.ExCapWeaponPassive;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.fml.ModList;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ImperatriceWeaponPassive
extends ExCapWeaponPassive {
    private static final UUID EVENT_UUID = UUID.fromString("2b3a8bea-cf7e-4710-ba98-68dc0f9bce30");
    private static final AnimationProvider<AttackAnimation> FORIXAIM_DRAW = () -> (AttackAnimation)BattleAnimations.TRUE_JOYEUSE_DRAW;

    public ImperatriceWeaponPassive(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        LogUtils.getLogger().debug(container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)container.getExecuter()).toString());
        if (ModList.get().isLoaded("battlearts_api")) {
            SkillContainer battleStyleContainer = container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE);
            PlayerPatch playerPatch = container.getExecuter();
            if (playerPatch instanceof ServerPlayerPatch) {
                Object object;
                ServerPlayerPatch playerPatch2 = (ServerPlayerPatch)playerPatch;
                if (!battleStyleContainer.isEmpty() && (object = battleStyleContainer.getSkill()) instanceof BattleStyle) {
                    BattleStyle battleStyle = (BattleStyle)object;
                    if (battleStyle.canModifyAttacks()) {
                        battleStyleContainer.requestExecute(playerPatch2, null);
                    }
                    if (!battleStyle.getWeaponDrawAnimations().isEmpty()) {
                        for (Pair animationProviderPair : battleStyle.getWeaponDrawAnimations()) {
                            if (container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() != animationProviderPair.getFirst() || animationProviderPair.getFirst() != BattleStyleCategories.ORIGIN_JOYEUSE) continue;
                            if (Minecraft.m_91087_().m_91094_().m_92545_().equals("42479ed5a8f04967bfb17500577896a6") || DebugControls.unconditionalUserCheck) {
                                if (FORIXAIM_DRAW.get() == null) continue;
                                container.getExecuter().playAnimationSynchronized(FORIXAIM_DRAW.get(), 0.0f);
                                continue;
                            }
                            container.getExecuter().playAnimationSynchronized(((AnimationProvider)animationProviderPair.getSecond()).get(), 0.0f);
                        }
                    }
                }
            }
        }
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executor) {
        return true;
    }
}

